using System;
using System.Collections.Generic;
using System.Linq;
using Vector2 = (long x, long y);

namespace Petlja
{
    internal class Program
    {
        private static void Main()
        {
            int n = int.Parse(Console.ReadLine() ?? "0");
            List<Vector2> points = [];

            for (int i = 0; i < n; i++)
            {
                string[] input = (Console.ReadLine() ?? "0 0").Split(' ');
                points.Add((long.Parse(input[0]), long.Parse(input[1])));
            }

            float minArea = float.MaxValue;
            for (int i = 0; i < points.Count; i++)
            {
                List<Vector2> reducedPoints = new(points);
                reducedPoints.RemoveAt(i);

                List<Vector2> reducedHull = GetConvexHullFor(reducedPoints);
                float reducedHullArea = PolygonArea(reducedHull);
                minArea = Math.Min(minArea, reducedHullArea);
            }

            Console.WriteLine(minArea);
        }

        public static long CrossProduct(Vector2 a, Vector2 b, Vector2 c) => ((b.x - a.x) * (c.y - a.y)) - ((b.y - a.y) * (c.x - a.x));

        public static float PolygonArea(List<Vector2> points)
        {
            float area = 0;
            int n = points.Count;
            for (int i = 0; i < n; i++)
            {
                int j = (i + 1) % n;
                area += points[i].x * points[j].y;
                area -= points[i].y * points[j].x;
            }
            return Math.Abs(area) / 2;
        }

        public static List<Vector2> GetConvexHullFor(List<Vector2> points)
        {
            points = [.. points.OrderBy(x => x.y).ThenBy(x => x.x)];

            List<Vector2> lower = [];
            foreach (Vector2 p in points)
            {
                while (lower.Count >= 2 && CrossProduct(lower[^2], lower[^1], p) <= 0)
                    lower.RemoveAt(lower.Count - 1);

                lower.Add(p);
            }

            List<Vector2> upper = [];
            foreach (Vector2 p in points.AsEnumerable().Reverse())
            {
                while (upper.Count >= 2 && CrossProduct(upper[^2], upper[^1], p) <= 0)
                    upper.RemoveAt(upper.Count - 1);

                upper.Add(p);
            }

            lower.RemoveAt(lower.Count - 1);
            upper.RemoveAt(upper.Count - 1);

            return [.. lower, .. upper];
        }
    }
}